<?php
/*
Plugin Name: PageLoader by Bonfire 
Plugin URI: http://bonfirethemes.com/
Description: Loading Screen and Progress Bar for WordPress. Customize under Appearance → Customize → PageLoader Plugin.
Version: 4.6
Author: Bonfire Themes
Author URI: http://bonfirethemes.com/
Text Domain: pageloader
Domain Path: /languages
License: GPL2
*/

    //
	// WORDPRESS LIVE CUSTOMIZER
	//
    function pageloader_theme_customizer( $wp_customize ) {

        //
        // ADD "PAGELOADER" PANEL TO LIVE CUSTOMIZER
        //
        $wp_customize->add_panel('pageloader_panel', array('title' => esc_html__('PageLoader Plugin', 'pageloader'),'priority' => 10,));
        
        //
        // ADD "Image" SECTION TO "PAGELOADER" PANEL 
        //
        $wp_customize->add_section('pageloader_image_section',array('title' => esc_html__( 'Image', 'pageloader' ),'panel' => 'pageloader_panel','priority' => 10));

        /* custom loading image */
        $wp_customize->add_setting('pageloader_custom_loading_image');
        $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize,'pageloader_custom_loading_image',
            array(
                'label' => esc_html__('Image', 'pageloader'),
                'section' => 'pageloader_image_section',
                'settings' => 'pageloader_custom_loading_image'
        )
        ));
        
        /* loading image from url */
        $wp_customize->add_setting('pageloader_custom_loading_image_url',array('sanitize_callback' => 'sanitize_pageloader_custom_loading_image_url',));
        function sanitize_pageloader_custom_loading_image_url($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('pageloader_custom_loading_image_url',array(
            'type' => 'text',
            'label' => esc_html__('Image from URL', 'pageloader'),
            'description' => esc_html__('If you need to use an off-site image as your loading image, enter its URL here (will override image selection above).', 'pageloader'),
            'section' => 'pageloader_image_section',
        ));

        /* image vertical position */
        $wp_customize->add_setting('pageloader_image_vertical_position',array(
            'default' => 'middle',
        ));
        $wp_customize->add_control('pageloader_image_vertical_position',array(
            'type' => 'select',
            'label' => esc_html__('Image vertical position', 'pageloader'),
            'section' => 'pageloader_image_section',
            'choices' => array(
                'top' => 'Top',
                'middle' => 'Middle',
                'bottom' => 'Bottom',
        ),
        ));

        /* image vertical fine-tune */
        $wp_customize->add_setting('pageloader_image_vertical_position_finetune',array('sanitize_callback' => 'sanitize_pageloader_image_vertical_position_finetune',));
        function sanitize_pageloader_image_vertical_position_finetune($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('pageloader_image_vertical_position_finetune',array(
            'type' => 'text',
            'label' => esc_html__('Fine-tune image vertical position (in pixels)', 'pageloader'),
            'description' => esc_html__('Negative values accepted. Example: 50 or -50', 'pageloader'),
            'section' => 'pageloader_image_section',
        ));
        
        /* image horizontal position */
        $wp_customize->add_setting('pageloader_image_horizontal_position',array(
            'default' => 'center',
        ));
        $wp_customize->add_control('pageloader_image_horizontal_position',array(
            'type' => 'select',
            'label' => esc_html__('Image horizontal position', 'pageloader'),
            'section' => 'pageloader_image_section',
            'choices' => array(
                'left' => 'Left',
                'center' => 'Center',
                'right' => 'Right',
        ),
        ));

        /* image horizontal fine-tune */
        $wp_customize->add_setting('pageloader_image_horizontal_position_finetune',array('sanitize_callback' => 'sanitize_pageloader_image_horizontal_position_finetune',));
        function sanitize_pageloader_image_horizontal_position_finetune($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('pageloader_image_horizontal_position_finetune',array(
            'type' => 'text',
            'label' => esc_html__('Fine-tune image horizontal position (in pixels)', 'pageloader'),
            'description' => esc_html__('Negative values accepted. Example: 50 or -50', 'pageloader'),
            'section' => 'pageloader_image_section',
        ));
        
        /* loading image size */
        $wp_customize->add_setting('pageloader_custom_loading_image_size',array('sanitize_callback' => 'sanitize_pageloader_custom_loading_image_size',));
        function sanitize_pageloader_custom_loading_image_size($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('pageloader_custom_loading_image_size',array(
            'type' => 'text',
            'label' => esc_html__('Image size (in pixels)', 'pageloader'),
            'description' => esc_html__('By default, the default size of the image is used (but gets sized down gradually depending on screen size to prevent it from going beyond screen bounds).', 'pageloader'),
            'section' => 'pageloader_image_section',
        ));

        /* loading image alt text */
        $wp_customize->add_setting('pageloader_custom_loading_image_alt_text',array('sanitize_callback' => 'sanitize_pageloader_custom_loading_image_alt_text',));
        function sanitize_pageloader_custom_loading_image_alt_text($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('pageloader_custom_loading_image_alt_text',array(
            'type' => 'text',
            'label' => esc_html__('Image ALT text', 'pageloader'),
            'description' => esc_html__('If you would like ALT text added to the image, add it here.', 'pageloader'),
            'section' => 'pageloader_image_section',
        ));

        /* pulsating loading image */
        $wp_customize->add_setting('pageloader_custom_loading_image_pulsate',array('sanitize_callback' => 'sanitize_pageloader_custom_loading_image_pulsate',));
        function sanitize_pageloader_custom_loading_image_pulsate($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('pageloader_custom_loading_image_pulsate',array(
            'type' => 'text',
            'label' => esc_html__('Image pulsating speed (in seconds)', 'pageloader'),
            'description' => esc_html__('Example: 0.75 or 2.5. If empty, pulsating is disabled.', 'pageloader'),
            'section' => 'pageloader_image_section',
        ));

        /* loading image blur effect */
        $wp_customize->add_setting('pageloader_image_blur',array('sanitize_callback' => 'sanitize_pageloader_image_blur',));
        function sanitize_pageloader_image_blur($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('pageloader_image_blur',array(
            'type' => 'text',
            'label' => esc_html__('Blur effect (in pixels)', 'pageloader'),
            'description' => esc_html__('Adds blur effect to loading image on load start. Note: effect may not yet be perfectly supported by all browsers. Example: 10', 'pageloader'),
            'section' => 'pageloader_image_section',
        ));
        
        /* loading image opacity */
        $wp_customize->add_setting('pageloader_image_opacity',array('sanitize_callback' => 'sanitize_pageloader_image_opacity',));
        function sanitize_pageloader_image_opacity( $input ) { if ( $input === true ) { return 1; } else { return ''; } }
        $wp_customize->add_control('pageloader_image_opacity',array('type' => 'checkbox','label' => esc_html__('Fade in image on load start.', 'pageloader'),'section' => 'pageloader_image_section',));
        
        /* loading image animation effect animation speed */
        $wp_customize->add_setting('pageloader_image_fade_blur_animation_speed',array('sanitize_callback' => 'sanitize_pageloader_image_fade_blur_animation_speed',));
        function sanitize_pageloader_image_fade_blur_animation_speed($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('pageloader_image_fade_blur_animation_speed',array(
            'type' => 'text',
            'label' => esc_html__('Blur/opacity animation speeds (in seconds)', 'pageloader'),
            'description' => esc_html__('Example: 5. If empty, defaults to 2.', 'pageloader'),
            'section' => 'pageloader_image_section',
        ));

        //
        // ADD "Icon" SECTION TO "PAGELOADER" PANEL 
        //
        $wp_customize->add_section('pageloader_icon_section',array('title' => esc_html__( 'Icon', 'pageloader' ),'panel' => 'pageloader_panel','priority' => 10));

        /* hide icon */
        $wp_customize->add_setting('pageloader_hide_icon',array('sanitize_callback' => 'sanitize_pageloader_hide_icon',));
        function sanitize_pageloader_hide_icon( $input ) { if ( $input === true ) { return 1; } else { return ''; } }
        $wp_customize->add_control('pageloader_hide_icon',array('type' => 'checkbox','label' => esc_html__('Hide icon', 'pageloader'),'description' => esc_html__('If checked, the loading icon will not be displayed.', 'pageloader'),'section' => 'pageloader_icon_section',));
        
        /* icon selection */
        $wp_customize->add_setting('pageloader_icon_selection',array(
            'default' => 'icon1',
        ));
        $wp_customize->add_control('pageloader_icon_selection',array(
            'type' => 'select',
            'label' => esc_html__('Icon style', 'pageloader'),
            'section' => 'pageloader_icon_section',
            'choices' => array(
                'icon1' => 'Icon 1',
                'icon2' => 'Icon 2',
                'icon3' => 'Icon 3',
                'icon4' => 'Icon 4',
                'icon5' => 'Icon 5',
                'icon6' => 'Icon 6',
                'icon7' => 'Icon 7',
                'icon8' => 'Icon 8',
                'icon9' => 'Icon 9',
                'icon10' => 'Icon 10',
        ),
        ));

        /* icon vertical position */
        $wp_customize->add_setting('pageloader_icon_vertical_position',array(
            'default' => 'middle',
        ));
        $wp_customize->add_control('pageloader_icon_vertical_position',array(
            'type' => 'select',
            'label' => esc_html__('Icon vertical position', 'pageloader'),
            'section' => 'pageloader_icon_section',
            'choices' => array(
                'top' => 'Top',
                'middle' => 'Middle',
                'bottom' => 'Bottom',
        ),
        ));

        /* icon vertical fine-tune */
        $wp_customize->add_setting('pageloader_icon_vertical_position_finetune',array('sanitize_callback' => 'sanitize_pageloader_icon_vertical_position_finetune',));
        function sanitize_pageloader_icon_vertical_position_finetune($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('pageloader_icon_vertical_position_finetune',array(
            'type' => 'text',
            'label' => esc_html__('Fine-tune icon vertical position (in pixels)', 'pageloader'),
            'description' => esc_html__('Negative values accepted. Example: 50 or -50', 'pageloader'),
            'section' => 'pageloader_icon_section',
        ));
        
        /* icon horizontal position */
        $wp_customize->add_setting('pageloader_icon_horizontal_position',array(
            'default' => 'center',
        ));
        $wp_customize->add_control('pageloader_icon_horizontal_position',array(
            'type' => 'select',
            'label' => esc_html__('Icon horizontal position', 'pageloader'),
            'section' => 'pageloader_icon_section',
            'choices' => array(
                'left' => 'Left',
                'center' => 'Center',
                'right' => 'Right',
        ),
        ));

        /* icon horizontal fine-tune */
        $wp_customize->add_setting('pageloader_icon_horizontal_position_finetune',array('sanitize_callback' => 'sanitize_pageloader_icon_horizontal_position_finetune',));
        function sanitize_pageloader_icon_horizontal_position_finetune($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('pageloader_icon_horizontal_position_finetune',array(
            'type' => 'text',
            'label' => esc_html__('Fine-tune icon horizontal position (in pixels)', 'pageloader'),
            'description' => esc_html__('Negative values accepted. Example: 50 or -50', 'pageloader'),
            'section' => 'pageloader_icon_section',
        ));

        /* icon animation speed */
        $wp_customize->add_setting('pageloader_icon_animation_speed',array('sanitize_callback' => 'sanitize_pageloader_icon_animation_speed',));
        function sanitize_pageloader_icon_animation_speed($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('pageloader_icon_animation_speed',array(
            'type' => 'text',
            'label' => esc_html__('Icon animation speed (in seconds)', 'pageloader'),
            'description' => esc_html__('Example: 0.5 or 2.5. If empty, defaults to icon default speed', 'pageloader'),
            'section' => 'pageloader_icon_section',
        ));

        /* icon scaling */
        $wp_customize->add_setting('pageloader_icon_scaling',array('sanitize_callback' => 'sanitize_pageloader_icon_scaling',));
        function sanitize_pageloader_icon_scaling($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('pageloader_icon_scaling',array(
            'type' => 'text',
            'label' => esc_html__('Icon scaling', 'pageloader'),
            'description' => esc_html__('Change size of the loading icon. Example: 0.5 or 2.5. If empty, defaults to 1', 'pageloader'),
            'section' => 'pageloader_icon_section',
        ));
        
        /* icon color (primary) */
        $wp_customize->add_setting('pageloader_icon_color', array('sanitize_callback' => 'sanitize_hex_color' ));
        $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'pageloader_icon_color',array(
            'label' => esc_html__('Icon color (primary)', 'pageloader'), 'settings' => 'pageloader_icon_color', 'section' => 'pageloader_icon_section' )
        ));

        /* icon color (secondary) */
        $wp_customize->add_setting('pageloader_secondary_icon_color', array('sanitize_callback' => 'sanitize_hex_color' ));
        $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'pageloader_secondary_icon_color',array(
            'label' => esc_html__('Icon color (secondary, when applicable)', 'pageloader'), 'settings' => 'pageloader_secondary_icon_color', 'section' => 'pageloader_icon_section' )
        ));
        
        /* loading icon blur effect */
        $wp_customize->add_setting('pageloader_icon_blur',array('sanitize_callback' => 'sanitize_pageloader_icon_blur',));
        function sanitize_pageloader_icon_blur($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('pageloader_icon_blur',array(
            'type' => 'text',
            'label' => esc_html__('Blur effect (in pixels)', 'pageloader'),
            'description' => esc_html__('Adds blur effect to loading icon on load start. Note: effect may not yet be perfectly supported by all browsers. Example: 10', 'pageloader'),
            'section' => 'pageloader_icon_section',
        ));
        
        /* loading icon opacity */
        $wp_customize->add_setting('pageloader_icon_opacity',array('sanitize_callback' => 'sanitize_pageloader_icon_opacity',));
        function sanitize_pageloader_icon_opacity( $input ) { if ( $input === true ) { return 1; } else { return ''; } }
        $wp_customize->add_control('pageloader_icon_opacity',array('type' => 'checkbox','label' => esc_html__('Fade in loading icon on load start.', 'pageloader'),'section' => 'pageloader_icon_section',));
        
        /* loading icon animation effect animation speed */
        $wp_customize->add_setting('pageloader_icon_fade_blur_animation_speed',array('sanitize_callback' => 'sanitize_pageloader_icon_fade_blur_animation_speed',));
        function sanitize_pageloader_icon_fade_blur_animation_speed($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('pageloader_icon_fade_blur_animation_speed',array(
            'type' => 'text',
            'label' => esc_html__('Blur/fade animation speeds (in seconds)', 'pageloader'),
            'description' => esc_html__('Example: 5. If empty, defaults to 2.', 'pageloader'),
            'section' => 'pageloader_icon_section',
        ));
        
        //
        // ADD "Text" SECTION TO "PAGELOADER" PANEL 
        //
        $wp_customize->add_section('pageloader_text_section',array('title' => esc_html__( 'Text', 'pageloader' ),'panel' => 'pageloader_panel','priority' => 10));
        
        /* loading text #1 */
        $wp_customize->add_setting('pageloader_custom_loading_text',array('sanitize_callback' => 'sanitize_pageloader_custom_loading_text',));
        function sanitize_pageloader_custom_loading_text($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('pageloader_custom_loading_text',array(
            'type' => 'text',
            'label' => esc_html__('Loading text', 'pageloader'),
            'description' => esc_html__('A short sentence to display under the loading icon. If empty, no text will be shown. If multiple fields are filled, sentences will be randomized.', 'pageloader'),
            'section' => 'pageloader_text_section',
        ));

        /* loading text #2 */
        $wp_customize->add_setting('pageloader_custom_loading_text2',array('sanitize_callback' => 'sanitize_pageloader_custom_loading_text2',));
        function sanitize_pageloader_custom_loading_text2($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('pageloader_custom_loading_text2',array(
            'type' => 'text',
            'section' => 'pageloader_text_section',
        ));
        
        /* loading text #3 */
        $wp_customize->add_setting('pageloader_custom_loading_text3',array('sanitize_callback' => 'sanitize_pageloader_custom_loading_text3',));
        function sanitize_pageloader_custom_loading_text3($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('pageloader_custom_loading_text3',array(
            'type' => 'text',
            'section' => 'pageloader_text_section',
        ));

        /* loading text #4 */
        $wp_customize->add_setting('pageloader_custom_loading_text4',array('sanitize_callback' => 'sanitize_pageloader_custom_loading_text4',));
        function sanitize_pageloader_custom_loading_text4($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('pageloader_custom_loading_text4',array(
            'type' => 'text',
            'section' => 'pageloader_text_section',
        ));

        /* loading text #5 */
        $wp_customize->add_setting('pageloader_custom_loading_text5',array('sanitize_callback' => 'sanitize_pageloader_custom_loading_text5',));
        function sanitize_pageloader_custom_loading_text5($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('pageloader_custom_loading_text5',array(
            'type' => 'text',
            'section' => 'pageloader_text_section',
        ));

        /* loading text vertical position */
        $wp_customize->add_setting('pageloader_loading_text_vertical_position',array(
            'default' => 'middle',
        ));
        $wp_customize->add_control('pageloader_loading_text_vertical_position',array(
            'type' => 'select',
            'label' => esc_html__('Text vertical position', 'pageloader'),
            'section' => 'pageloader_text_section',
            'choices' => array(
                'top' => 'Top',
                'middle' => 'Middle',
                'bottom' => 'Bottom',
        ),
        ));

        /* loading text vertical fine-tune */
        $wp_customize->add_setting('pageloader_loading_text_vertical_position_finetune',array('sanitize_callback' => 'sanitize_pageloader_loading_text_vertical_position_finetune',));
        function sanitize_pageloader_loading_text_vertical_position_finetune($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('pageloader_loading_text_vertical_position_finetune',array(
            'type' => 'text',
            'label' => esc_html__('Fine-tune text vertical position (in pixels)', 'pageloader'),
            'description' => esc_html__('Negative values accepted. Example: 50 or -50', 'pageloader'),
            'section' => 'pageloader_text_section',
        ));
        
        /* loading text horizontal position */
        $wp_customize->add_setting('pageloader_loading_text_horizontal_position',array(
            'default' => 'center',
        ));
        $wp_customize->add_control('pageloader_loading_text_horizontal_position',array(
            'type' => 'select',
            'label' => esc_html__('Text horizontal position', 'pageloader'),
            'section' => 'pageloader_text_section',
            'choices' => array(
                'left' => 'Left',
                'center' => 'Center',
                'right' => 'Right',
        ),
        ));

        /* loading text horizontal fine-tune */
        $wp_customize->add_setting('pageloader_loading_text_horizontal_position_finetune',array('sanitize_callback' => 'sanitize_pageloader_loading_text_horizontal_position_finetune',));
        function sanitize_pageloader_loading_text_horizontal_position_finetune($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('pageloader_loading_text_horizontal_position_finetune',array(
            'type' => 'text',
            'label' => esc_html__('Fine-tune text horizontal position (in pixels)', 'pageloader'),
            'description' => esc_html__('Negative values accepted. Example: 50 or -50', 'pageloader'),
            'section' => 'pageloader_text_section',
        ));
        
        /* text color */
        $wp_customize->add_setting('pageloader_text_color', array('sanitize_callback' => 'sanitize_hex_color' ));
        $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'pageloader_text_color',array(
            'label' => esc_html__('Text', 'pageloader'), 'settings' => 'pageloader_text_color', 'section' => 'pageloader_text_section' )
        ));

        /* loading text font size */
        $wp_customize->add_setting('pageloader_loading_text_font_size',array('sanitize_callback' => 'sanitize_pageloader_loading_text_font_size',));
        function sanitize_pageloader_loading_text_font_size($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('pageloader_loading_text_font_size',array(
            'type' => 'text',
            'label' => esc_html__('Text font size (in pixels)', 'pageloader'),
            'description' => esc_html__('Font size for the loading text. If empty, will default to 14', 'pageloader'),
            'section' => 'pageloader_text_section',
        ));

        /* loading text letter spacing */
        $wp_customize->add_setting('pageloader_loading_text_letter_spacing',array('sanitize_callback' => 'sanitize_pageloader_loading_text_letter_spacing',));
        function sanitize_pageloader_loading_text_letter_spacing($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('pageloader_loading_text_letter_spacing',array(
            'type' => 'text',
            'label' => esc_html__('Text letter spacing (in pixels)', 'pageloader'),
            'description' => esc_html__('If empty, will default to 0', 'pageloader'),
            'section' => 'pageloader_text_section',
        ));

        /* loading text slide-in*/
        $wp_customize->add_setting('pageloader_sentence_slidein',array('sanitize_callback' => 'sanitize_pageloader_sentence_slidein',));
        function sanitize_pageloader_sentence_slidein( $input ) {if ( $input === true ) {return 1;} else {return '';}}
        $wp_customize->add_control('pageloader_sentence_slidein',array('type' => 'checkbox','label' => esc_html__('Loading text slide-in', 'pageloader'),'description' => esc_html__('When enabled, the loading text has a brief slide-in animation.', 'pageloader'),'section' => 'pageloader_text_section',));
        
        /* use theme font */
        $wp_customize->add_setting('pageloader_text_theme_font',array('default' => '','sanitize_callback' => 'sanitize_pageloader_text_theme_font',));
        function sanitize_pageloader_text_theme_font($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('pageloader_text_theme_font',array('type' => 'text','label' => esc_html__('Advanced feature: Use theme font', 'pageloader'),'description' => esc_html__('If you know the name of and would like to use one of your theme fonts, enter it in the textfield below as it appears in the theme stylesheet.', 'pageloader'),'section' => 'pageloader_text_section',));
        
        //
        // ADD "Close Function" SECTION TO "PAGELOADER" PANEL
        //
        $wp_customize->add_section('pageloader_close_function_section',array('title' => esc_html__( 'Close Function', 'pageloader' ),'panel' => 'pageloader_panel','priority' => 10));
        
        /* close button delay */
        $wp_customize->add_setting('pageloader_custom_close_delay',array('sanitize_callback' => 'sanitize_pageloader_custom_close_delay',));
        function sanitize_pageloader_custom_close_delay($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('pageloader_custom_close_delay',array(
            'type' => 'text',
            'label' => esc_html__('Close button delay (in milliseconds)', 'pageloader'),
            'description' => esc_html__('Example: 2000 or 3500 (2 and 3.5 seconds respectively). If empty, feature is disabled.', 'pageloader'),
            'section' => 'pageloader_close_function_section',
        ));
        
        /* close button text */
        $wp_customize->add_setting('pageloader_custom_close_text',array('sanitize_callback' => 'sanitize_pageloader_custom_close_text',));
        function sanitize_pageloader_custom_close_text($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('pageloader_custom_close_text',array(
            'type' => 'text',
            'label' => esc_html__('Close button text', 'pageloader'),
            'description' => esc_html__('If empty, will default to "Taking too long? Close loading screen."', 'pageloader'),
            'section' => 'pageloader_close_function_section',
        ));
        
        /* close button text color */
        $wp_customize->add_setting('pageloader_close_color', array( 'sanitize_callback' => 'sanitize_hex_color'));
        $wp_customize->add_control(new WP_Customize_Color_Control( $wp_customize, 'pageloader_close_color',array(
            'label' => esc_html__('Close button text', 'pageloader'), 'settings' => 'pageloader_close_color', 'section' => 'pageloader_close_function_section')
        ));

        /* close button text color (hover) */
        $wp_customize->add_setting('pageloader_close_hover_color', array( 'sanitize_callback' => 'sanitize_hex_color'));
        $wp_customize->add_control(new WP_Customize_Color_Control( $wp_customize, 'pageloader_close_hover_color',array(
            'label' => esc_html__('Close button text (hover)', 'pageloader'), 'settings' => 'pageloader_close_hover_color', 'section' => 'pageloader_close_function_section')
        ));

        /* close button background color */
        $wp_customize->add_setting('pageloader_close_background_color', array( 'sanitize_callback' => 'sanitize_hex_color'));
        $wp_customize->add_control(new WP_Customize_Color_Control( $wp_customize, 'pageloader_close_background_color',array(
            'label' => esc_html__('Close button background', 'pageloader'), 'settings' => 'pageloader_close_background_color', 'section' => 'pageloader_close_function_section')
        ));

        /* close button background color (hover) */
        $wp_customize->add_setting('pageloader_close_background_hover_color', array( 'sanitize_callback' => 'sanitize_hex_color'));
        $wp_customize->add_control(new WP_Customize_Color_Control( $wp_customize, 'pageloader_close_background_hover_color',array(
            'label' => esc_html__('Close button background (hover)', 'pageloader'), 'settings' => 'pageloader_close_background_hover_color', 'section' => 'pageloader_close_function_section')
        ));

        /* close button corner roundness */
        $wp_customize->add_setting('pageloader_close_roundness',array('sanitize_callback' => 'sanitize_pageloader_close_roundness',));
        function sanitize_pageloader_close_roundness($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('pageloader_close_roundness',array(
            'type' => 'text',
            'label' => esc_html__('Close button roundness', 'pageloader'),
            'description' => esc_html__('Example: 5 or 25. If empty, will default to 3', 'pageloader'),
            'section' => 'pageloader_close_function_section',
        ));

        /* use theme font */
        $wp_customize->add_setting('pageloader_close_theme_font',array('default' => '','sanitize_callback' => 'sanitize_pageloader_close_theme_font',));
        function sanitize_pageloader_close_theme_font($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('pageloader_close_theme_font',array('type' => 'text','label' => esc_html__('Advanced feature: Use theme font', 'pageloader'),'description' => esc_html__('If you know the name of and would like to use one of your theme fonts, enter it in the textfield below as it appears in the theme stylesheet.', 'pageloader'),'section' => 'pageloader_close_function_section',));

        //
        // ADD "Progress Bar" SECTION TO "PAGELOADER" PANEL 
        //
        $wp_customize->add_section('pageloader_progressbar_section',array('title' => esc_html__( 'Progress Bar', 'pageloader' ),'panel' => 'pageloader_panel','priority' => 10));
        
        /* disable progress bar */
        $wp_customize->add_setting('pageloader_progressbar_disable',array('sanitize_callback' => 'sanitize_pageloader_progressbar_disable',));
        function sanitize_pageloader_progressbar_disable( $input ) { if ( $input === true ) { return 1; } else { return ''; } }
        $wp_customize->add_control('pageloader_progressbar_disable',array('type' => 'checkbox','label' => esc_html__('Disable progress bar', 'pageloader'),'section' => 'pageloader_progressbar_section',));
        
        /* disable progress bar on touch devices only */
        $wp_customize->add_setting('pageloader_progressbar_disable_touch',array('sanitize_callback' => 'sanitize_pageloader_progressbar_disable_touch',));
        function sanitize_pageloader_progressbar_disable_touch( $input ) { if ( $input === true ) { return 1; } else { return ''; } }
        $wp_customize->add_control('pageloader_progressbar_disable_touch',array('type' => 'checkbox','label' => esc_html__('Disable progress bar (on touch devices only)', 'pageloader'),'description' => esc_html__('Due to some mobile browsers already having a built-in loading bar, you may wish to enable this option to hide the PageLoader bar on touch devices.', 'pageloader'),'section' => 'pageloader_progressbar_section',));
        
        /* progress bar vertical position */
        $wp_customize->add_setting('pageloader_progressbar_vertical_position',array(
            'default' => 'top',
        ));
        $wp_customize->add_control('pageloader_progressbar_vertical_position',array(
            'type' => 'select',
            'label' => esc_html__('Progress bar vertical position', 'pageloader'),
            'section' => 'pageloader_progressbar_section',
            'choices' => array(
                'top' => 'Top',
                'middle' => 'Middle',
                'bottom' => 'Bottom',
        ),
        ));

        /* progress bar vertical fine-tune */
        $wp_customize->add_setting('pageloader_progressbar_vertical_position_finetune',array('sanitize_callback' => 'sanitize_pageloader_progressbar_vertical_position_finetune',));
        function sanitize_pageloader_progressbar_vertical_position_finetune($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('pageloader_progressbar_vertical_position_finetune',array(
            'type' => 'text',
            'label' => esc_html__('Fine-tune progress bar vertical position (in pixels)', 'pageloader'),
            'description' => esc_html__('Negative values accepted. Example: 50 or -50', 'pageloader'),
            'section' => 'pageloader_progressbar_section',
        ));
        
        /* progress bar horizontal position */
        $wp_customize->add_setting('pageloader_progressbar_horizontal_position',array(
            'default' => 'center',
        ));
        $wp_customize->add_control('pageloader_progressbar_horizontal_position',array(
            'type' => 'select',
            'label' => esc_html__('Progress bar horizontal position', 'pageloader'),
            'section' => 'pageloader_progressbar_section',
            'choices' => array(
                'left' => 'Left',
                'center' => 'Center',
                'right' => 'Right',
        ),
        ));

        /* progress bar horizontal fine-tune */
        $wp_customize->add_setting('pageloader_progressbar_horizontal_position_finetune',array('sanitize_callback' => 'sanitize_pageloader_progressbar_horizontal_position_finetune',));
        function sanitize_pageloader_progressbar_horizontal_position_finetune($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('pageloader_progressbar_horizontal_position_finetune',array(
            'type' => 'text',
            'label' => esc_html__('Fine-tune progress bar horizontal position (in pixels)', 'pageloader'),
            'description' => esc_html__('Negative values accepted. Example: 50 or -50', 'pageloader'),
            'section' => 'pageloader_progressbar_section',
        ));

        /* progress bar width */
        $wp_customize->add_setting('pageloader_progressbar_width',array('sanitize_callback' => 'sanitize_pageloader_progressbar_width',));
        function sanitize_pageloader_progressbar_width($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('pageloader_progressbar_width',array(
            'type' => 'text',
            'label' => esc_html__('Progress bar width (in pixels)', 'pageloader'),
            'description' => esc_html__('Example: 500. If empty, defaults to full width.', 'pageloader'),
            'section' => 'pageloader_progressbar_section',
        ));
        
        /* progress bar height */
        $wp_customize->add_setting('pageloader_progressbar_height',array('sanitize_callback' => 'sanitize_pageloader_progressbar_height',));
        function sanitize_pageloader_progressbar_height($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('pageloader_progressbar_height',array(
            'type' => 'text',
            'label' => esc_html__('Progress bar height (in pixels)', 'pageloader'),
            'description' => esc_html__('Example: 5 or 10. If empty, defaults to 3.', 'pageloader'),
            'section' => 'pageloader_progressbar_section',
        ));

        /* progress bar padding */
        $wp_customize->add_setting('pageloader_progressbar_padding',array('sanitize_callback' => 'sanitize_pageloader_progressbar_padding',));
        function sanitize_pageloader_progressbar_padding($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('pageloader_progressbar_padding',array(
            'type' => 'text',
            'label' => esc_html__('Progress bar padding (in pixels)', 'pageloader'),
            'description' => esc_html__('Example: 10. If empty, defaults to 0.', 'pageloader'),
            'section' => 'pageloader_progressbar_section',
        ));

        /* progress bar color */
        $wp_customize->add_setting('pageloader_progressbar_color', array('sanitize_callback' => 'sanitize_hex_color' ));
        $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'pageloader_progressbar_color',array(
            'label' => esc_html__('Progress bar', 'pageloader'), 'settings' => 'pageloader_progressbar_color', 'section' => 'pageloader_progressbar_section' )
        ));
        
        /* progress bar gradient color */
        $wp_customize->add_setting('pageloader_progressbar_color_gradient', array('sanitize_callback' => 'sanitize_hex_color' ));
        $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'pageloader_progressbar_color_gradient',array(
            'label' => esc_html__('Progress bar gradient', 'pageloader'), 'description' => 'To add a gradient effect to the progress bar, pick a secondary color here.', 'settings' => 'pageloader_progressbar_color_gradient', 'section' => 'pageloader_progressbar_section' )
        ));
        
        /* progress bar background color */
        $wp_customize->add_setting('pageloader_progressbar_background_color', array('sanitize_callback' => 'sanitize_hex_color' ));
        $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'pageloader_progressbar_background_color',array(
            'label' => esc_html__('Progress bar background', 'pageloader'), 'settings' => 'pageloader_progressbar_background_color', 'section' => 'pageloader_progressbar_section' )
        ));

        /* progress bar corner roundness */
        $wp_customize->add_setting('pageloader_progressbar_corner',array('sanitize_callback' => 'sanitize_pageloader_progressbar_corner',));
        function sanitize_pageloader_progressbar_corner($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('pageloader_progressbar_corner',array(
            'type' => 'text',
            'label' => esc_html__('Progress bar corner roundness (in pixels)', 'pageloader'),
            'description' => esc_html__('Example: 5 or 10. If empty, defaults to 0.', 'pageloader'),
            'section' => 'pageloader_progressbar_section',
        ));

        /* show progressbar only */
        $wp_customize->add_setting('pageloader_progressbar_only',array('sanitize_callback' => 'sanitize_pageloader_progressbar_only',));
        function sanitize_pageloader_progressbar_only( $input ) { if ( $input === true ) { return 1; } else { return ''; } }
        $wp_customize->add_control('pageloader_progressbar_only',array('type' => 'checkbox','label' => esc_html__('Show progress bar only', 'pageloader'),'description' => esc_html__('If ticked, all other elements (the loading screen, icon/image etc.) will be hidden. Only the progress bar will be displayed.', 'pageloader'),'section' => 'pageloader_progressbar_section',));
        
        /* show progressbar full screen */
        $wp_customize->add_setting('pageloader_progressbar_fullscreen',array('sanitize_callback' => 'sanitize_pageloader_progressbar_fullscreen',));
        function sanitize_pageloader_progressbar_fullscreen( $input ) { if ( $input === true ) { return 1; } else { return ''; } }
        $wp_customize->add_control('pageloader_progressbar_fullscreen',array('type' => 'checkbox','label' => esc_html__('Show progress bar full-screen', 'pageloader'),'description' => esc_html__('If ticked, all other positioning settings will be ignored.', 'pageloader'),'section' => 'pageloader_progressbar_section',));

        //
        // ADD "Background" SECTION TO "PAGELOADER" PANEL 
        //
        $wp_customize->add_section('pageloader_background_section',array('title' => esc_html__( 'Background', 'pageloader' ),'panel' => 'pageloader_panel','priority' => 10));
        
        /* enable pre-load animation */
        $wp_customize->add_setting('pageloader_preload_animation',array('sanitize_callback' => 'sanitize_pageloader_preload_animation',));
        function sanitize_pageloader_preload_animation( $input ) { if ( $input === true ) { return 1; } else { return ''; } }
        $wp_customize->add_control('pageloader_preload_animation',array('type' => 'checkbox','label' => esc_html__('Enable pre-load animation', 'pageloader'),'description' => 'Check this to enable the Appearance animation setting below','section' => 'pageloader_background_section',));
        
        /* pre-load background animation */
        $wp_customize->add_setting('pageloader_preload_background_animation',array(
            'default' => 'fade',
        ));
        $wp_customize->add_control('pageloader_preload_background_animation',array(
            'type' => 'select',
            'label' => esc_html__('Appearance animation', 'pageloader'),
            'section' => 'pageloader_background_section',
            'choices' => array(
                'fade' => 'Fade in',
                'top' => 'Slide from top',
                'left' => 'Slide from left',
                'right' => 'Slide from right',
                'bottom' => 'Slide from bottom',
        ),
        ));

        /* background animation */
        $wp_customize->add_setting('pageloader_background_animation',array(
            'default' => 'fade',
        ));
        $wp_customize->add_control('pageloader_background_animation',array(
            'type' => 'select',
            'label' => esc_html__('Disappearance animation', 'pageloader'),
            'section' => 'pageloader_background_section',
            'choices' => array(
                'fade' => 'Fade away',
                'top' => 'Slide to top',
                'left' => 'Slide to left',
                'right' => 'Slide to right',
                'bottom' => 'Slide to bottom',
        ),
        ));
        
        /* disappearance speed */
        $wp_customize->add_setting('pageloader_disappearance_speed',array('sanitize_callback' => 'sanitize_pageloader_disappearance_speed',));
        function sanitize_pageloader_disappearance_speed($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('pageloader_disappearance_speed',array(
            'type' => 'text',
            'label' => esc_html__('Speed (in seconds)', 'pageloader'),
            'description' => esc_html__('The speed at which the loading screen animates. Example: 0.75 or 2. If empty, defaults to 1.', 'pageloader'),
            'section' => 'pageloader_background_section',
        ));
        
        /* disappearance scaling */
        $wp_customize->add_setting('pageloader_background_scaling',array('sanitize_callback' => 'sanitize_pageloader_background_scaling',));
        function sanitize_pageloader_background_scaling($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('pageloader_background_scaling',array(
            'type' => 'text',
            'label' => esc_html__('Scaling', 'pageloader'),
            'description' => esc_html__('The scale to which the loading screen animates. Example: 0.75 or 1.25. If empty, defaults to 1 (no scaling).', 'pageloader'),
            'section' => 'pageloader_background_section',
        ));
        
        /* background color */
        $wp_customize->add_setting('pageloader_background_color', array('sanitize_callback' => 'sanitize_hex_color' ));
        $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'pageloader_background_color',array(
            'label' => esc_html__('Background color', 'pageloader'), 'settings' => 'pageloader_background_color', 'section' => 'pageloader_background_section' )
        ));

        /* background color (secondary) */
        $wp_customize->add_setting('pageloader_background_color_secondary', array('sanitize_callback' => 'sanitize_hex_color' ));
        $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'pageloader_background_color_secondary',array(
            'label' => esc_html__('Background color (secondary)', 'pageloader'), 'description' => esc_html__('When secondary color chosen, background will fade between the two colors.', 'pageloader'), 'settings' => 'pageloader_background_color_secondary', 'section' => 'pageloader_background_section' )
        ));

        /* background as gradient */
        $wp_customize->add_setting('pageloader_background_gradient',array('sanitize_callback' => 'sanitize_pageloader_background_gradient',));
        function sanitize_pageloader_background_gradient( $input ) { if ( $input === true ) { return 1; } else { return ''; } }
        $wp_customize->add_control('pageloader_background_gradient',array('type' => 'checkbox','label' => esc_html__('Show secondary background color as gradient', 'pageloader'),'section' => 'pageloader_background_section',));

        /* background color speed */
        $wp_customize->add_setting('pageloader_background_color_speed',array('sanitize_callback' => 'sanitize_pageloader_background_color_speed',));
        function sanitize_pageloader_background_color_speed($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('pageloader_background_color_speed',array(
            'type' => 'text',
            'label' => esc_html__('Background color speed (in seconds)', 'pageloader'),
            'description' => esc_html__('Example: 1.5 or 5. If empty, defaults to 3.', 'pageloader'),
            'section' => 'pageloader_background_section',
        ));

        /* background opacity */
        $wp_customize->add_setting('pageloader_background_opacity',array('sanitize_callback' => 'sanitize_pageloader_background_opacity',));
        function sanitize_pageloader_background_opacity($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('pageloader_background_opacity',array(
            'type' => 'text',
            'label' => esc_html__('Background opacity (from 0-1)', 'pageloader'),
            'description' => esc_html__('Example: 0.25 or 0.5. If empty, defaults to 1.', 'pageloader'),
            'section' => 'pageloader_background_section',
        ));
        
        /* background image */
        $wp_customize->add_setting('pageloader_background_image');
        $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize,'pageloader_background_image',
            array(
                'label' => esc_html__('Background image', 'pageloader'),
                'section' => 'pageloader_background_section',
                'settings' => 'pageloader_background_image'
        )
        ));
        
        /* background as cover */
        $wp_customize->add_setting('pageloader_background_cover',array('sanitize_callback' => 'sanitize_pageloader_background_cover',));
        function sanitize_pageloader_background_cover( $input ) { if ( $input === true ) { return 1; } else { return ''; } }
        $wp_customize->add_control('pageloader_background_cover',array('type' => 'checkbox','label' => esc_html__('Show background image in full screen', 'pageloader'),'section' => 'pageloader_background_section',));
        
        /* background image opacity */
        $wp_customize->add_setting('pageloader_background_image_opacity',array('sanitize_callback' => 'sanitize_pageloader_background_image_opacity',));
        function sanitize_pageloader_background_image_opacity($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('pageloader_background_image_opacity',array(
            'type' => 'text',
            'label' => esc_html__('Background image opacity (from 0-1)', 'pageloader'),
            'description' => esc_html__('Example: 0.4 or 0.95. If empty, defaults to .2.', 'pageloader'),
            'section' => 'pageloader_background_section',
        ));
        
        //
        // ADD "Layered Background" SECTION TO "PAGELOADER" PANEL 
        //
        $wp_customize->add_section('pageloader_layered_background_section',array('title' => esc_html__( 'Layered Background', 'pageloader' ),'panel' => 'pageloader_panel','priority' => 10));
        
        /* enable pre-load animation */
        $wp_customize->add_setting('pageloader_layered_background_enabled',array('sanitize_callback' => 'sanitize_pageloader_layered_background_enabled',));
        function sanitize_pageloader_layered_background_enabled( $input ) { if ( $input === true ) { return 1; } else { return ''; } }
        $wp_customize->add_control('pageloader_layered_background_enabled',array('type' => 'checkbox','label' => esc_html__('Enable layered background animation', 'pageloader'),'description' => 'When enabled, the background settings in the "Background" section are ignored.','section' => 'pageloader_layered_background_section',));
        
        /* enable pre-load animation */
        $wp_customize->add_setting('pageloader_layered_preload_animation',array('sanitize_callback' => 'sanitize_pageloader_layered_preload_animation',));
        function sanitize_pageloader_layered_preload_animation( $input ) { if ( $input === true ) { return 1; } else { return ''; } }
        $wp_customize->add_control('pageloader_layered_preload_animation',array('type' => 'checkbox','label' => esc_html__('Enable pre-load animation', 'pageloader'),'description' => 'Check this to enable the Appearance animation setting below','section' => 'pageloader_layered_background_section',));
        
        /* pre-load background animation */
        $wp_customize->add_setting('pageloader_preload_layered_background_animation',array(
            'default' => 'left',
        ));
        $wp_customize->add_control('pageloader_preload_layered_background_animation',array(
            'type' => 'select',
            'label' => esc_html__('Appearance animation', 'pageloader'),
            'section' => 'pageloader_layered_background_section',
            'choices' => array(
                'top' => 'Slide from top',
                'left' => 'Slide from left',
                'right' => 'Slide from right',
                'bottom' => 'Slide from bottom',
        ),
        ));

        /* background animation */
        $wp_customize->add_setting('pageloader_layered_background_animation',array(
            'default' => 'right',
        ));
        $wp_customize->add_control('pageloader_layered_background_animation',array(
            'type' => 'select',
            'label' => esc_html__('Disappearance animation', 'pageloader'),
            'section' => 'pageloader_layered_background_section',
            'choices' => array(
                'top' => 'Slide to top',
                'left' => 'Slide to left',
                'right' => 'Slide to right',
                'bottom' => 'Slide to bottom',
        ),
        ));

        /* background color (top layer) */
        $wp_customize->add_setting('pageloader_layered_background_one_color', array('sanitize_callback' => 'sanitize_hex_color' ));
        $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'pageloader_layered_background_one_color',array(
            'label' => esc_html__('Background color (top layer)', 'pageloader'), 'settings' => 'pageloader_layered_background_one_color', 'section' => 'pageloader_layered_background_section' )
        ));
        /* background color (bottom layer) */
        $wp_customize->add_setting('pageloader_layered_background_two_color', array('sanitize_callback' => 'sanitize_hex_color' ));
        $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'pageloader_layered_background_two_color',array(
            'label' => esc_html__('Background color (bottom layer)', 'pageloader'), 'settings' => 'pageloader_layered_background_two_color', 'section' => 'pageloader_layered_background_section' )
        ));

        //
        // ADD "Background Overlay" SECTION TO "PAGELOADER" PANEL 
        //
        $wp_customize->add_section('pageloader_overlay_section',array('title' => esc_html__( 'Background Overlay', 'pageloader' ),'panel' => 'pageloader_panel','priority' => 10));
        
        /* background overlay opacity */
        $wp_customize->add_setting('pageloader_background_overlay_opacity',array('sanitize_callback' => 'sanitize_pageloader_background_overlay_opacity',));
        function sanitize_pageloader_background_overlay_opacity($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('pageloader_background_overlay_opacity',array(
            'type' => 'text',
            'label' => esc_html__('Background overlay opacity (from 0-1)', 'pageloader'),
            'description' => esc_html__('Example: 0.5 or 1. If empty, defaults to 0.', 'pageloader'),
            'section' => 'pageloader_overlay_section',
        ));

        /* background overlay color */
        $wp_customize->add_setting('pageloader_background_overlay_color', array('sanitize_callback' => 'sanitize_hex_color' ));
        $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'pageloader_background_overlay_color',array(
            'label' => esc_html__('Background overlay color', 'pageloader'), 'settings' => 'pageloader_background_overlay_color', 'section' => 'pageloader_overlay_section' )
        ));
        
        //
        // ADD "Content Slide-in" SECTION TO "PAGELOADER" PANEL 
        //
        $wp_customize->add_section('pageloader_slidein_section',array('title' => esc_html__( 'Content Slide-in, Scaling', 'pageloader' ),'description' => esc_html__( 'Note: This feature might cause styling conflicts with some themes/plugins, for example ones that override default browser behavior or ones that already have their own content animations.' ),'panel' => 'pageloader_panel','priority' => 10));
        
        /* slide-in content */
        $wp_customize->add_setting('pageloader_slidein_content',array('sanitize_callback' => 'sanitize_pageloader_slidein_content',));
        function sanitize_pageloader_slidein_content( $input ) { if ( $input === true ) { return 1; } else { return ''; } }
        $wp_customize->add_control('pageloader_slidein_content',array('type' => 'checkbox','label' => esc_html__('Content animation', 'pageloader'),'description' => esc_html__('Enables content animation as loading screen closes.', 'pageloader'),'section' => 'pageloader_slidein_section',));
        
        /* custom elements */
        $wp_customize->add_setting('pageloader_slidein_custom_elements',array('sanitize_callback' => 'sanitize_pageloader_slidein_custom_elements',));
        function sanitize_pageloader_slidein_custom_elements($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('pageloader_slidein_custom_elements',array(
            'type' => 'text',
            'label' => esc_html__('Only target specific elements', 'pageloader'),
            'description' => esc_html__('By default, PageLoader will attempt to apply animation to your entire site body. If you find some elements acting up though, or if you want to apply animation only to specific elements, then use this text field to target those elements. Separate classes/IDs by comma.', 'pageloader'),
            'section' => 'pageloader_slidein_section',
        ));
        
        /* content animation speed */
        $wp_customize->add_setting('pageloader_slidein_speed',array('sanitize_callback' => 'sanitize_pageloader_slidein_speed',));
        function sanitize_pageloader_slidein_speed($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('pageloader_slidein_speed',array(
            'type' => 'text',
            'label' => esc_html__('Animation speed (in seconds)', 'pageloader'),
            'description' => esc_html__('Example: 0.75 or 2. If empty, defaults to 1.', 'pageloader'),
            'section' => 'pageloader_slidein_section',
        ));
        
        /* slide-in distance */
        $wp_customize->add_setting('pageloader_slidein_distance',array('sanitize_callback' => 'sanitize_pageloader_slidein_distance',));
        function sanitize_pageloader_slidein_distance($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('pageloader_slidein_distance',array(
            'type' => 'text',
            'label' => esc_html__('Slide-in distance (in pixels)', 'pageloader'),
            'description' => esc_html__('Example: 50 or -250 (enter negative value to slide-in from the top). If empty, defaults to -100.', 'pageloader'),
            'section' => 'pageloader_slidein_section',
        ));
        
        /* content scaling */
        $wp_customize->add_setting('pageloader_content_scaling',array('sanitize_callback' => 'sanitize_pageloader_content_scaling',));
        function sanitize_pageloader_content_scaling($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('pageloader_content_scaling',array(
            'type' => 'text',
            'label' => esc_html__('Content scaling', 'pageloader'),
            'description' => esc_html__('Example: 0.95 or 1.25. If empty, defaults to 1 (no scaling).', 'pageloader'),
            'section' => 'pageloader_slidein_section',
        ));
        
        /* content opacity */
        $wp_customize->add_setting('pageloader_content_opacity',array('sanitize_callback' => 'sanitize_pageloader_content_opacity',));
        function sanitize_pageloader_content_opacity($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('pageloader_content_opacity',array(
            'type' => 'text',
            'label' => esc_html__('Content opacity (0-1)', 'pageloader'),
            'description' => esc_html__('Example: 0.5. If empty, defaults to 1.', 'pageloader'),
            'section' => 'pageloader_slidein_section',
        ));

        /* disable content animation for pre-load */
        $wp_customize->add_setting('pageloader_slidein_content_preload_disable',array('sanitize_callback' => 'sanitize_pageloader_slidein_content_preload_disable',));
        function sanitize_pageloader_slidein_content_preload_disable( $input ) { if ( $input === true ) { return 1; } else { return ''; } }
        $wp_customize->add_control('pageloader_slidein_content_preload_disable',array('type' => 'checkbox','label' => esc_html__('Disable content animation for pre-load', 'pageloader'),'description' => esc_html__('When enabled, site content is animated only when loading screen disappears.', 'pageloader'),'section' => 'pageloader_slidein_section',));
        
        //
        // ADD "Misc." SECTION TO "PAGELOADER" PANEL 
        //
        $wp_customize->add_section('pageloader_misc_section',array('title' => esc_html__( 'Misc.', 'pageloader' ),'panel' => 'pageloader_panel','priority' => 10));
        
        /* show on mobile only */
        $wp_customize->add_setting('pageloader_mobile_only',array('sanitize_callback' => 'sanitize_pageloader_mobile_only',));
        function sanitize_pageloader_mobile_only( $input ) { if ( $input === true ) { return 1; } else { return ''; } }
        $wp_customize->add_control('pageloader_mobile_only',array('type' => 'checkbox','label' => esc_html__('Show on touch devices only', 'pageloader'),'description' => esc_html__('The loading screen will be shown on touch devices only.', 'pageloader'),'section' => 'pageloader_misc_section',));
        
        /* show on front page only */
        $wp_customize->add_setting('pageloader_front_page_only',array('sanitize_callback' => 'sanitize_pageloader_front_page_only',));
        function sanitize_pageloader_front_page_only( $input ) { if ( $input === true ) { return 1; } else { return ''; } }
        $wp_customize->add_control('pageloader_front_page_only',array('type' => 'checkbox','label' => esc_html__('Show on front page only', 'pageloader'),'description' => esc_html__('The loading screen will be shown on the front page only.', 'pageloader'),'section' => 'pageloader_misc_section',));
        
        /* show once per browser session */
        $wp_customize->add_setting('pageloader_browser_session',array('sanitize_callback' => 'sanitize_pageloader_browser_session',));
        function sanitize_pageloader_browser_session( $input ) {if ( $input === true ) {return 1;} else {return '';}}
        $wp_customize->add_control('pageloader_browser_session',array('type' => 'checkbox','label' => esc_html__('Show once per session', 'pageloader'),'description' => esc_html__('The loading screen is shown only once per visitor browser session.', 'pageloader'),'section' => 'pageloader_misc_section',));
        
        /* loading elements slide-in*/
        $wp_customize->add_setting('pageloader_elements_slidein',array('sanitize_callback' => 'sanitize_pageloader_elements_slidein',));
        function sanitize_pageloader_elements_slidein( $input ) {if ( $input === true ) {return 1;} else {return '';}}
        $wp_customize->add_control('pageloader_elements_slidein',array('type' => 'checkbox','label' => esc_html__('Loading elements slide-in', 'pageloader'),'description' => esc_html__('When enabled, the loading icon/image and other loading elements have a brief slide-in animation.', 'pageloader'),'section' => 'pageloader_misc_section',));
        
        /* unload GFont */
        $wp_customize->add_setting('pageloader_unload_gfont',array('sanitize_callback' => 'sanitize_pageloader_unload_gfont',));
        function sanitize_pageloader_unload_gfont( $input ) { if ( $input === true ) { return 1; } else { return ''; } }
        $wp_customize->add_control('pageloader_unload_gfont',array('type' => 'checkbox','label' => esc_html__('Unload GoogleFont', 'pageloader'),'description' => esc_html__('Useful when not making use of the loading or close function text features, or when using the theme font feature.', 'pageloader'),'section' => 'pageloader_misc_section',));

        /* custom delay */
        $wp_customize->add_setting('pageloader_custom_delay',array('sanitize_callback' => 'sanitize_pageloader_custom_delay',));
        function sanitize_pageloader_custom_delay($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('pageloader_custom_delay',array(
            'type' => 'text',
            'label' => esc_html__('Custom delay (in milliseconds)', 'pageloader'),
            'description' => esc_html__('Upon load completion, the loading screen will remain visible for the specified amount of time. Example: 500 or 1500 (0.5 and 1.5 seconds respectively).', 'pageloader'),
            'section' => 'pageloader_misc_section',
        ));

        /* autoclose after */
        $wp_customize->add_setting('pageloader_autoclose_after',array('sanitize_callback' => 'sanitize_pageloader_autoclose_after',));
        function sanitize_pageloader_autoclose_after($input) {return wp_kses_post(force_balance_tags($input));}
        $wp_customize->add_control('pageloader_autoclose_after',array(
            'type' => 'text',
            'label' => esc_html__('Automatically close after (in milliseconds)', 'pageloader'),
            'description' => esc_html__('Automatically close loading screen after specified amount of time. If this setting is used, the loading screen will close when the specified time passes or the page finishes loading, whichever happens quicker. Example: 500 or 1500 (0.5 and 1.5 seconds respectively).', 'pageloader'),
            'section' => 'pageloader_misc_section',
        ));

        //
        // ADD "A message from the developer" SECTION TO "PageLoader Plugin" PANEL
        //
        $wp_customize->add_section('pageloader_other_items_section',array('title' => esc_html__('A message from the developer','pageloader'), 'panel' => 'pageloader_panel'));

        require_once 'custom_controls.php';
        /* custom notice custom contol */
        $wp_customize->add_setting('custom_info', array(
            'default'           => '',
            'sanitize_callback' => 'pageloader_other_items_sanitization',
        ));
        $wp_customize->add_control(new Info_Custom_control($wp_customize, 'custom_info', array(
            'settings'		=> 'custom_info',
            'section'  		=> 'pageloader_other_items_section',
        )));

    }
    add_action('customize_register', 'pageloader_theme_customizer');
    
    //
	// Once per session option
	//
    if( get_theme_mod('pageloader_browser_session', '') !== '') {
        add_action('init', 'pageloader_register_session');
        function pageloader_register_session() {
            if( !session_id() ) {
                session_start();
            }
        }
    }

	//
	// Insert PageLoader into the header
	//
	function bonfire_pageloader_header() {

        if (!isset($_SESSION['pageloader_session'])) { $_SESSION['pageloader_session'] = '0';
            if( get_theme_mod('pageloader_front_page_only', '') !== '') {
                if( is_front_page() || is_home() ) {
                    if( get_theme_mod('pageloader_mobile_only', '') !== '') {
                        if ( wp_is_mobile() ) {
                            include( plugin_dir_path( __FILE__ ) . 'include.php');
                        }
                    } else {
                        include( plugin_dir_path( __FILE__ ) . 'include.php');
                    }
                }
            } else {
                // BEGIN GET POST ID (FOR PER-POST/PAGE PageLoader HIDE)
                global $post;
                $bonfire_pageloader_display = get_post_meta($post->ID, 'bonfire_pageloader_display', true);
                //END GET POST ID (FOR PER-POST/PAGE PageLoader HIDE)
                
                if( get_theme_mod('pageloader_mobile_only', '') !== '') {
                    if ( wp_is_mobile() ) {
                        include( plugin_dir_path( __FILE__ ) . 'include.php');
                    }
                } else {
                    include( plugin_dir_path( __FILE__ ) . 'include.php');
                }
            }
        } $_SESSION['pageloader_session']++;
	
	}
	add_action('wp_head','bonfire_pageloader_header', 9);

    //
	// ENQUEUE Google WebFonts
	//
    if( get_theme_mod('pageloader_unload_gfont', '') === '') {
        function pageloader_fonts_url() {
            $font_url = '';

            if ( 'off' !== _x( 'on', 'Google font: on or off', 'pageloader' ) ) {
                $font_url = add_query_arg( 'family', urlencode( 'Muli:700' ), "//fonts.googleapis.com/css" );
            }
            return $font_url;
        }
        function pageloader_scripts() {
            if (!isset($_SESSION['pageloader_session_gfont'])) { $_SESSION['pageloader_session_gfont'] = '0';
                wp_enqueue_style( 'pageloader-fonts', pageloader_fonts_url(), array(), '1.0.0' );
            } $_SESSION['pageloader_session_gfont']++;
        }
        add_action( 'wp_enqueue_scripts', 'pageloader_scripts' );
    }


	//
	// ENQUEUE pageloader.css (only when loading screen visible)
	//   
	function bonfire_pageloader_css() {
        if (!isset($_SESSION['pageloader_session_css'])) { $_SESSION['pageloader_session_css'] = '0';
            if( get_theme_mod('pageloader_front_page_only', '') !== '') {
                if( is_front_page() || is_home() ) {
                    if( get_theme_mod('pageloader_mobile_only', '') !== '') {
                        if ( wp_is_mobile() ) {
                            wp_register_style( 'bonfire-pageloader-styles', plugins_url( '/pageloader.css', __FILE__ ) . '', array(), '1', 'all' );
                            wp_enqueue_style( 'bonfire-pageloader-styles' );
                        }
                    } else {
                        wp_register_style( 'bonfire-pageloader-styles', plugins_url( '/pageloader.css', __FILE__ ) . '', array(), '1', 'all' );
                        wp_enqueue_style( 'bonfire-pageloader-styles' );
                    }
                }
            } else {
                // BEGIN GET POST ID (FOR PER-POST/PAGE PageLoader HIDE)
                global $post;
                $bonfire_pageloader_display = get_post_meta($post->ID, 'bonfire_pageloader_display', true);
                //END GET POST ID (FOR PER-POST/PAGE PageLoader HIDE)
                
                if( get_theme_mod('pageloader_mobile_only', '') !== '') {
                    if ( wp_is_mobile() ) {
                        wp_register_style( 'bonfire-pageloader-styles', plugins_url( '/pageloader.css', __FILE__ ) . '', array(), '1', 'all' );
                        wp_enqueue_style( 'bonfire-pageloader-styles' );
                    }
                } else {
                    wp_register_style( 'bonfire-pageloader-styles', plugins_url( '/pageloader.css', __FILE__ ) . '', array(), '1', 'all' );
                    wp_enqueue_style( 'bonfire-pageloader-styles' );
                }
            }
        } $_SESSION['pageloader_session_css']++;
	}
	add_action( 'wp_enqueue_scripts', 'bonfire_pageloader_css', 1 );


	//
	// ENQUEUE pageloader.js (only when loading screen visible)
	//
	function bonfire_pageloader_js() {
        if (!isset($_SESSION['pageloader_session_js'])) { $_SESSION['pageloader_session_js'] = '0';
            if( get_theme_mod('pageloader_front_page_only', '') !== '') {
                if( is_front_page() || is_home() ) {
                    if( get_theme_mod('pageloader_mobile_only', '') !== '') {
                        if ( wp_is_mobile() ) {
                            wp_register_script( 'bonfire-pageloader-scripts', plugins_url( '/pageloader.js', __FILE__ ) . '', array( 'jquery' ), '1' );  
                            wp_enqueue_script( 'bonfire-pageloader-scripts' );
                        }
                    } else {
                        wp_register_script( 'bonfire-pageloader-scripts', plugins_url( '/pageloader.js', __FILE__ ) . '', array( 'jquery' ), '1' );  
                        wp_enqueue_script( 'bonfire-pageloader-scripts' );
                    }
                }
            } else {
                // BEGIN GET POST ID (FOR PER-POST/PAGE PageLoader HIDE)
                global $post;
                $bonfire_pageloader_display = get_post_meta($post->ID, 'bonfire_pageloader_display', true);
                //END GET POST ID (FOR PER-POST/PAGE PageLoader HIDE)
                
                if( get_theme_mod('pageloader_mobile_only', '') !== '') {
                    if ( wp_is_mobile() ) {
                        wp_register_script( 'bonfire-pageloader-scripts', plugins_url( '/pageloader.js', __FILE__ ) . '', array( 'jquery' ), '1' );  
                        wp_enqueue_script( 'bonfire-pageloader-scripts' );
                    }
                } else {
                    wp_register_script( 'bonfire-pageloader-scripts', plugins_url( '/pageloader.js', __FILE__ ) . '', array( 'jquery' ), '1' );  
                    wp_enqueue_script( 'bonfire-pageloader-scripts' );
                }
            }
        } $_SESSION['pageloader_session_js']++;
	}
	add_action( 'wp_enqueue_scripts', 'bonfire_pageloader_js' );

    //
	// Allow Shortcodes in Text Widget
	//
	add_filter('widget_text', 'do_shortcode');
	
	//
	// Register Widgets
	//
	function bonfire_pageloader_widgets_init() {

		register_sidebar( array(
		'name' => esc_html__( 'PageLoader Widgets', 'bonfire' ),
		'id' => 'pageloader-widgets',
		'description' => esc_html__( 'Drag widgets here', 'bonfire' ),
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget' => "</div>",
		'before_title' => '<h4 class="widgettitle">',
		'after_title' => '</h4>',
		));

	}
    add_action( 'widgets_init', 'bonfire_pageloader_widgets_init' );
    
    //
	// Translation-ready
	//
    function pageloader_load_plugin_textdomain() {
        load_plugin_textdomain( 'pageloader', FALSE, basename( dirname( __FILE__ ) ) . '/languages/' );
    }
    add_action( 'plugins_loaded', 'pageloader_load_plugin_textdomain' );
    
	//
	// Insert theme customizer options into the header
	//
	function bonfire_pageloader_header_customize() {
	?>
    
    <?php if (!isset($_SESSION['pageloader_session_customizer'])) { $_SESSION['pageloader_session_customizer'] = '0'; ?>

		<style>
        /* loading elements slide-in */
        <?php if( get_theme_mod('pageloader_elements_slidein', '') !== '') { ?>
        .pageloader-image-wrapper,
        .pageloader-icon-wrapper {
            animation-name:loading-elements-slide-in;
            animation-duration:1s;
        }
        <?php } ?>
        /* loading sentence slide-in */
        <?php if( get_theme_mod('pageloader_sentence_slidein', '') !== '') { ?>
        .pageloader-sentence-wrapper {
            animation-name:loading-elements-slide-in;
            animation-duration:1s;
        }
        <?php } ?>
        /* icon position */
        .pageloader-icon-inner {
            vertical-align:<?php if( get_theme_mod('pageloader_icon_vertical_position', '') === '') { ?>middle<?php } ?><?php $bonfire_pageloader_icon_vertical_position = get_theme_mod('pageloader_icon_vertical_position'); if($bonfire_pageloader_icon_vertical_position !== '') { switch ($bonfire_pageloader_icon_vertical_position) { ?><?php case 'top': ?>top<?php break; case 'middle': ?>middle<?php break; case 'bottom': ?>bottom<?php break; } } ?>;
            text-align:<?php if( get_theme_mod('pageloader_icon_horizontal_position', '') === '') { ?>center<?php } ?><?php $bonfire_pageloader_icon_horizontal_position = get_theme_mod('pageloader_icon_horizontal_position'); if($bonfire_pageloader_icon_horizontal_position !== '') { switch ($bonfire_pageloader_icon_horizontal_position) { ?><?php case 'left': ?>left<?php break; case 'center': ?>center<?php break; case 'right': ?>right<?php break; } } ?>;
        }
        .pageloader-icon {
            top:<?php echo get_theme_mod('pageloader_icon_vertical_position_finetune'); ?>px;
            left:<?php echo get_theme_mod('pageloader_icon_horizontal_position_finetune'); ?>px;
        }
        /* image position */
        .pageloader-image-inner {
            vertical-align:<?php if( get_theme_mod('pageloader_image_vertical_position', '') === '') { ?>middle<?php } ?><?php $bonfire_pageloader_image_vertical_position = get_theme_mod('pageloader_image_vertical_position'); if($bonfire_pageloader_image_vertical_position !== '') { switch ($bonfire_pageloader_image_vertical_position) { ?><?php case 'top': ?>top<?php break; case 'middle': ?>middle<?php break; case 'bottom': ?>bottom<?php break; } } ?>;
            text-align:<?php if( get_theme_mod('pageloader_image_horizontal_position', '') === '') { ?>center<?php } ?><?php $bonfire_pageloader_image_horizontal_position = get_theme_mod('pageloader_image_horizontal_position'); if($bonfire_pageloader_image_horizontal_position !== '') { switch ($bonfire_pageloader_image_horizontal_position) { ?><?php case 'left': ?>left<?php break; case 'center': ?>center<?php break; case 'right': ?>right<?php break; } } ?>;
        }
        .pageloader-image {
            top:<?php echo get_theme_mod('pageloader_image_vertical_position_finetune'); ?>px;
            left:<?php echo get_theme_mod('pageloader_image_horizontal_position_finetune'); ?>px;
        }
        /* loading text position */
        .pageloader-sentence-inner {
            vertical-align:<?php if( get_theme_mod('pageloader_loading_text_vertical_position', '') === '') { ?>middle<?php } ?><?php $bonfire_pageloader_loading_text_vertical_position = get_theme_mod('pageloader_loading_text_vertical_position'); if($bonfire_pageloader_loading_text_vertical_position !== '') { switch ($bonfire_pageloader_loading_text_vertical_position) { ?><?php case 'top': ?>top<?php break; case 'middle': ?>middle<?php break; case 'bottom': ?>bottom<?php break; } } ?>;
            text-align:<?php if( get_theme_mod('pageloader_loading_text_horizontal_position', '') === '') { ?>center<?php } ?><?php $bonfire_pageloader_loading_text_horizontal_position = get_theme_mod('pageloader_loading_text_horizontal_position'); if($bonfire_pageloader_loading_text_horizontal_position !== '') { switch ($bonfire_pageloader_loading_text_horizontal_position) { ?><?php case 'left': ?>left<?php break; case 'center': ?>center<?php break; case 'right': ?>right<?php break; } } ?>;
        }
        .pageloader-sentence {
            top:<?php echo get_theme_mod('pageloader_loading_text_vertical_position_finetune'); ?>px;
            left:<?php echo get_theme_mod('pageloader_loading_text_horizontal_position_finetune'); ?>px;
        }
        /* image size */
        .pageloader-image img {
            width:<?php echo get_theme_mod('pageloader_custom_loading_image_size'); ?>px;
        }
        /* image pulsating animation */
        .pageloader-image {
            animation:pulsateAnimation <?php echo get_theme_mod('pageloader_custom_loading_image_pulsate'); ?>s infinite;
            -webkit-animation:pulsateAnimation <?php echo get_theme_mod('pageloader_custom_loading_image_pulsate'); ?>s infinite;
        }
		/* background and icon color + background opacity */
		.bonfire-pageloader-background {
            background-color:<?php if( get_theme_mod('pageloader_background_color', '') !== '') { ?><?php echo get_theme_mod('pageloader_background_color'); ?><?php } else { ?>#202021<?php } ?>;
            opacity:<?php echo get_theme_mod('pageloader_background_opacity'); ?>;
        }

        /* secondary background color + fade between background colors */
        <?php if( get_theme_mod('pageloader_background_color_secondary', '') !== '' && get_theme_mod('pageloader_background_gradient', '') === '') { ?>
            .bonfire-pageloader-background {
                animation:plbganimation <?php if( get_theme_mod('pageloader_background_color_speed', '') !== '') { ?><?php echo get_theme_mod('pageloader_background_color_speed'); ?><?php } else { ?>3<?php } ?>s infinite;
                -webkit-animation:plbganimation <?php if( get_theme_mod('pageloader_background_color_speed', '') !== '') { ?><?php echo get_theme_mod('pageloader_background_color_speed'); ?><?php } else { ?>3<?php } ?>s infinite;
            }
            @-webkit-keyframes plbganimation {
                0% {background:<?php if( get_theme_mod('pageloader_background_color', '') !== '') { ?><?php echo get_theme_mod('pageloader_background_color'); ?><?php } else { ?>#202021<?php } ?>;}
                50% {background:<?php echo get_theme_mod('pageloader_background_color_secondary'); ?>;}
                100% {background:<?php if( get_theme_mod('pageloader_background_color', '') !== '') { ?><?php echo get_theme_mod('pageloader_background_color'); ?><?php } else { ?>#202021<?php } ?>;}
            }
            <?php } elseif( get_theme_mod('pageloader_background_color_secondary', '') !== '' && get_theme_mod('pageloader_background_gradient', '') !== '') { ?>
                .bonfire-pageloader-background {
                    background:<?php if( get_theme_mod('pageloader_background_color', '') !== '') { ?><?php echo get_theme_mod('pageloader_background_color'); ?><?php } else { ?>#202021<?php } ?>;
                    background:linear-gradient(320deg, <?php if( get_theme_mod('pageloader_background_color', '') !== '') { ?><?php echo get_theme_mod('pageloader_background_color'); ?><?php } else { ?>#202021<?php } ?>, <?php echo get_theme_mod('pageloader_background_color_secondary'); ?>);
                    background-size:300% 300%;

                    animation:plgradient <?php if( get_theme_mod('pageloader_background_color_speed', '') !== '') { ?><?php echo get_theme_mod('pageloader_background_color_speed'); ?><?php } else { ?>3<?php } ?>s infinite;
                    -webkit-animation:plgradient <?php if( get_theme_mod('pageloader_background_color_speed', '') !== '') { ?><?php echo get_theme_mod('pageloader_background_color_speed'); ?><?php } else { ?>3<?php } ?>s infinite;
                }
                @-webkit-keyframes plgradient {
                    0% { background-position:0% 50%; }
                    50% { background-position:100% 50%; }
                    100% { background-position:0% 50%; }
                }
                @keyframes plgradient {
                    0% { background-position:0% 50%; }
                    50% { background-position:100% 50%; }
                    100% { background-position:0% 50%; }
                }
            <?php } ?>

        .bonfire-pageloader-background-image { opacity:<?php echo get_theme_mod('pageloader_background_image_opacity'); ?>; }
        
        /* icon animation speed */
        .loader1 rect,
        .loader2 svg circle:first-of-type,
        .loader2 svg circle:last-of-type,
        .loader3 svg rect,
        .loader4 svg,
        .loader5 svg circle,
        .loader6 circle:first-of-type,
        .loader6 circle:nth-child(2),
        .loader6 circle:nth-child(3),
        .loader7 svg,
        .loader8 svg,
        .loader9 svg,
        .loader9 svg circle:nth-of-type(2),
        .loader9 svg circle:nth-of-type(3),
        .loader10 svg,
        .loader10 svg circle:first-of-type,
        .loader10 svg circle:nth-of-type(2),
        .loader10 svg circle:nth-of-type(3),
        .loader10 svg circle:last-of-type {
            animation-duration:<?php echo get_theme_mod('pageloader_icon_animation_speed'); ?>s;
        }
        /* icon scaling */
        .pageloader-icon {
            -webkit-transform:scale(<?php echo get_theme_mod('pageloader_icon_scaling'); ?>);
            transform:scale(<?php echo get_theme_mod('pageloader_icon_scaling'); ?>);
        }
        /* primary icon color */
		.loader1 svg,
        .loader2 circle:nth-child(2),
        .loader3 rect,
        .loader4 path,
        .loader6 circle,
        .loader7 path:nth-child(2),
        .loader8 circle,
        .loader9 svg,
        .loader10 svg {
            fill:<?php echo get_theme_mod('pageloader_icon_color'); ?>;
        }
        .loader5 circle {
            stroke:<?php echo get_theme_mod('pageloader_icon_color'); ?>;
        }
        @keyframes loader6dot1 {
            0% { transform:scale(1); fill:<?php if( get_theme_mod('pageloader_secondary_icon_color', '') !== '') { ?><?php echo get_theme_mod('pageloader_secondary_icon_color'); ?><?php } else { ?>#2A2A2A<?php } ?>; }
            16% { transform:scale(1.5); fill:<?php if( get_theme_mod('pageloader_icon_color', '') !== '') { ?><?php echo get_theme_mod('pageloader_icon_color'); ?><?php } else { ?>#9AA366<?php } ?>; }
            70%, 100% { transform:scale(1); fill:<?php if( get_theme_mod('pageloader_secondary_icon_color', '') !== '') { ?><?php echo get_theme_mod('pageloader_secondary_icon_color'); ?><?php } else { ?>#2A2A2A<?php } ?>; }
        }
        @keyframes loader6dot2 {
            0%, 30% { transform:scale(1); fill:<?php if( get_theme_mod('pageloader_secondary_icon_color', '') !== '') { ?><?php echo get_theme_mod('pageloader_secondary_icon_color'); ?><?php } else { ?>#2A2A2A<?php } ?>; }
            47% { transform:scale(1.5); fill:<?php if( get_theme_mod('pageloader_icon_color', '') !== '') { ?><?php echo get_theme_mod('pageloader_icon_color'); ?><?php } else { ?>#9AA366<?php } ?>; }
            75%, 100% { transform:scale(1); fill:<?php if( get_theme_mod('pageloader_secondary_icon_color', '') !== '') { ?><?php echo get_theme_mod('pageloader_secondary_icon_color'); ?><?php } else { ?>#2A2A2A<?php } ?>; }
        }
        @keyframes loader6dot3 {
            0%, 47% { transform:scale(1); fill:<?php if( get_theme_mod('pageloader_secondary_icon_color', '') !== '') { ?><?php echo get_theme_mod('pageloader_secondary_icon_color'); ?><?php } else { ?>#2A2A2A<?php } ?>; }
            83% { transform:scale(1.5); fill:<?php if( get_theme_mod('pageloader_icon_color', '') !== '') { ?><?php echo get_theme_mod('pageloader_icon_color'); ?><?php } else { ?>#9AA366<?php } ?>; }
            100% { transform:scale(1); fill:<?php if( get_theme_mod('pageloader_secondary_icon_color', '') !== '') { ?><?php echo get_theme_mod('pageloader_secondary_icon_color'); ?><?php } else { ?>#2A2A2A<?php } ?>; }
        }
        /* secondary icon color */
		.loader2 circle:first-child,
        .loader3 circle,
        .loader7 path:first-child,
        .loader8 path {
            fill:<?php echo get_theme_mod('pageloader_secondary_icon_color'); ?>;
        }
        /* loading sentence */
		.pageloader-sentence {
            font-size:<?php echo get_theme_mod('pageloader_loading_text_font_size'); ?>px;
            letter-spacing:<?php echo get_theme_mod('pageloader_loading_text_letter_spacing'); ?>px;
            color:<?php echo get_theme_mod('pageloader_text_color'); ?>;
            font-family:<?php echo get_theme_mod('pageloader_text_theme_font'); ?>;
        }
        /* close function */
        .pageloader-close {
            color:<?php echo get_theme_mod('pageloader_close_color'); ?>;
            font-family:<?php echo get_theme_mod('pageloader_close_theme_font'); ?>;
            background-color:<?php echo get_theme_mod('pageloader_close_background_color'); ?>;
            border-radius:<?php echo get_theme_mod('pageloader_close_roundness'); ?>px;
        }
        .pageloader-close:hover {
            color:<?php echo get_theme_mod('pageloader_close_hover_color'); ?>;
            background-color:<?php echo get_theme_mod('pageloader_close_background_hover_color'); ?>;
        }
        /* progress bar */
        #nprogress-wrapper {
            padding:<?php echo get_theme_mod('pageloader_progressbar_padding'); ?>px;
            <?php if( get_theme_mod('pageloader_progressbar_fullscreen', '') !== '') { ?>
                z-index:99999997;
            <?php } ?>
        }
        #nprogress-inner {
            vertical-align:<?php if( get_theme_mod('pageloader_progressbar_vertical_position', '') === '') { ?>top<?php } ?><?php $bonfire_pageloader_progressbar_vertical_position = get_theme_mod('pageloader_progressbar_vertical_position'); if($bonfire_pageloader_progressbar_vertical_position !== '') { switch ($bonfire_pageloader_progressbar_vertical_position) { ?><?php case 'top': ?>top<?php break; case 'middle': ?>middle<?php break; case 'bottom': ?>bottom<?php break; } } ?>;
            text-align:<?php if( get_theme_mod('pageloader_progressbar_horizontal_position', '') === '') { ?>center<?php } ?><?php $bonfire_pageloader_progressbar_horizontal_position = get_theme_mod('pageloader_progressbar_horizontal_position'); if($bonfire_pageloader_progressbar_horizontal_position !== '') { switch ($bonfire_pageloader_progressbar_horizontal_position) { ?><?php case 'left': ?>left<?php break; case 'center': ?>center<?php break; case 'right': ?>right<?php break; } } ?>;
        }
        #nprogress {
            <?php if( get_theme_mod('pageloader_progressbar_fullscreen', '') !== '') { ?>
                top:0;
                left:0;
                vertical-align:top;
                max-width:100%;
                height:100%;
                height:100vh;
                z-index:99999997 !important;
            <?php } else { ?>
                top:<?php echo get_theme_mod('pageloader_progressbar_vertical_position_finetune'); ?>px;
                left:<?php echo get_theme_mod('pageloader_progressbar_horizontal_position_finetune'); ?>px;
                vertical-align:<?php if( get_theme_mod('pageloader_progressbar_vertical_position', '') === 'bottom') { ?>bottom<?php } else { ?>top<?php } ?>;
                max-width:<?php if( get_theme_mod('pageloader_progressbar_width', '') !== '') { ?><?php echo get_theme_mod('pageloader_progressbar_width'); ?>px<?php } else { ?>100%<?php } ?>;
                height:<?php if( get_theme_mod('pageloader_progressbar_height', '') !== '') { ?><?php echo get_theme_mod('pageloader_progressbar_height'); ?><?php } else { ?>3<?php } ?>px;
            <?php } ?>
            background-color:<?php echo get_theme_mod('pageloader_progressbar_background_color'); ?>;
        }
        /* progress bar border radius */
        #nprogress,
        #nprogress .bar {
            border-radius:<?php echo get_theme_mod('pageloader_progressbar_corner'); ?>px;
        }
        /* progress bar colors (regular and gradient) */
        #nprogress .bar {
            background:<?php if( get_theme_mod('pageloader_progressbar_color', '') !== '') { ?><?php echo get_theme_mod('pageloader_progressbar_color'); ?><?php } else { ?>#4B6A87<?php } ?>;
            background:-webkit-gradient(left top, right top, color-stop(0%, <?php if( get_theme_mod('pageloader_progressbar_color', '') !== '') { ?><?php echo get_theme_mod('pageloader_progressbar_color'); ?><?php } else { ?>#4B6A87<?php } ?>), color-stop(100%, <?php if( get_theme_mod('pageloader_progressbar_color_gradient', '') !== '') { ?><?php echo get_theme_mod('pageloader_progressbar_color_gradient'); ?><?php } else { ?><?php echo get_theme_mod('pageloader_progressbar_color'); ?><?php } ?>));
            background:-webkit-linear-gradient(left, <?php if( get_theme_mod('pageloader_progressbar_color', '') !== '') { ?><?php echo get_theme_mod('pageloader_progressbar_color'); ?><?php } else { ?>#4B6A87<?php } ?> 0%, <?php if( get_theme_mod('pageloader_progressbar_color_gradient', '') !== '') { ?><?php echo get_theme_mod('pageloader_progressbar_color_gradient'); ?><?php } else { ?><?php echo get_theme_mod('pageloader_progressbar_color'); ?><?php } ?> 100%);
            background:-o-linear-gradient(left, <?php if( get_theme_mod('pageloader_progressbar_color', '') !== '') { ?><?php echo get_theme_mod('pageloader_progressbar_color'); ?><?php } else { ?>#4B6A87<?php } ?> 0%, <?php if( get_theme_mod('pageloader_progressbar_color_gradient', '') !== '') { ?><?php echo get_theme_mod('pageloader_progressbar_color_gradient'); ?><?php } else { ?>#4B6A87<?php } ?> 100%);
            background:-ms-linear-gradient(left, <?php if( get_theme_mod('pageloader_progressbar_color', '') !== '') { ?><?php echo get_theme_mod('pageloader_progressbar_color'); ?><?php } else { ?>#4B6A87<?php } ?> 0%, <?php if( get_theme_mod('pageloader_progressbar_color_gradient', '') !== '') { ?><?php echo get_theme_mod('pageloader_progressbar_color_gradient'); ?><?php } else { ?><?php echo get_theme_mod('pageloader_progressbar_color'); ?><?php } ?> 100%);
            background:linear-gradient(to right, <?php if( get_theme_mod('pageloader_progressbar_color', '') !== '') { ?><?php echo get_theme_mod('pageloader_progressbar_color'); ?><?php } else { ?>#4B6A87<?php } ?> 0%, <?php if( get_theme_mod('pageloader_progressbar_color_gradient', '') !== '') { ?><?php echo get_theme_mod('pageloader_progressbar_color_gradient'); ?><?php } else { ?><?php echo get_theme_mod('pageloader_progressbar_color'); ?><?php } ?> 100%);
            filter:progid:DXImageTransform.Microsoft.gradient( startColorstr='<?php if( get_theme_mod('pageloader_progressbar_color', '') !== '') { ?><?php echo get_theme_mod('pageloader_progressbar_color'); ?><?php } else { ?>#4B6A87<?php } ?>', endColorstr='<?php if( get_theme_mod('pageloader_progressbar_color_gradient', '') !== '') { ?><?php echo get_theme_mod('pageloader_progressbar_color_gradient'); ?><?php } else { ?><?php echo get_theme_mod('pageloader_progressbar_color'); ?><?php } ?>', GradientType=1 );
        }
        /* hide nProgress if PageLoader disabled (singular) */
        <?php if(is_singular() ) { ?>
        <?php $meta_value = get_post_meta( get_the_ID(), 'bonfire_pageloader_display', true ); if( !empty( $meta_value ) ) { ?>
        #nprogress { display:none !important; }
        <?php } ?>
        <?php } ?>
		</style>
		<!-- END CUSTOM COLORS (WP THEME CUSTOMIZER) -->
	
    <?php } $_SESSION['pageloader_session_customizer']++; ?>
    
	<?php
	}
	add_action('wp_head','bonfire_pageloader_header_customize', 8);
    

    //
	// Add pre-load animation jQuery + CSS to footer
	//
    function bonfire_pageloader_footer() {

    if( get_theme_mod('pageloader_preload_animation', '') !== '' && get_theme_mod('pageloader_layered_background_enabled', '') === '' || get_theme_mod('pageloader_layered_preload_animation', '') !== '' && get_theme_mod('pageloader_layered_background_enabled', '') !== '') {
        if (!isset($_SESSION['pageloader_session_preload'])) { $_SESSION['pageloader_session_preload'] = '0';
            if( get_theme_mod('pageloader_front_page_only', '') !== '') {
                if( is_front_page() || is_home() ) {
                    if( get_theme_mod('pageloader_mobile_only', '') !== '') {
                        if ( wp_is_mobile() ) {
                            include( plugin_dir_path( __FILE__ ) . 'preload.php');
                        }
                    } else {
                        include( plugin_dir_path( __FILE__ ) . 'preload.php');
                    }
                }
            } else {
                // BEGIN GET POST ID (FOR PER-POST/PAGE PageLoader HIDE)
                global $post;
                $bonfire_pageloader_display = get_post_meta($post->ID, 'bonfire_pageloader_display', true);
                //END GET POST ID (FOR PER-POST/PAGE PageLoader HIDE)
                
                if( get_theme_mod('pageloader_mobile_only', '') !== '') {
                    if ( wp_is_mobile() ) {
                        include( plugin_dir_path( __FILE__ ) . 'preload.php');
                    }
                } else {
                    include( plugin_dir_path( __FILE__ ) . 'preload.php');
                }
            }
        } $_SESSION['pageloader_session_preload']++;
    }

	}
	add_action('wp_footer','bonfire_pageloader_footer', 200);
    
    //
	// Add 'Settings' link to plugin page
	//
    add_filter( 'plugin_action_links_' . plugin_basename(__FILE__), 'add_action_links' );
    function add_action_links ( $links ) {
        $mylinks = array(
        '<a href="' . admin_url( 'customize.php?autofocus[panel]=pageloader_panel' ) . '">Settings</a>',
        );
    return array_merge( $links, $mylinks );
    }

	///////////////////////////////////////
	// Yes/No drop-down selector on 'write post/page' pages
	///////////////////////////////////////
	add_action( 'add_meta_boxes', 'bonfire_pageloader_custom_class_add' );
	function bonfire_pageloader_custom_class_add() {
		add_meta_box( 'bonfire-pageloader-meta-box-id', esc_html__( 'Show PageLoader loading screen on this post?', 'bonfire' ), 'bonfire_pageloader_custom_class', 'post', 'normal', 'high' );
		add_meta_box( 'bonfire-pageloader-meta-box-id', esc_html__( 'Show PageLoader loading screen on this page?', 'bonfire' ), 'bonfire_pageloader_custom_class', 'page', 'normal', 'high' );
	}

	function bonfire_pageloader_custom_class( $post ) {
		$values = get_post_custom( $post->ID );
		$bonfire_pageloader_selected_class = isset( $values['bonfire_pageloader_display'] ) ? esc_attr( $values['bonfire_pageloader_display'][0] ) : '';
		?>		
		<p>
			<select name="bonfire_pageloader_display">
				<option value="" <?php selected( $bonfire_pageloader_selected_class, 'yes' ); ?>>Yes</option>
				<!-- You can add and remove options starting from here -->				
				<option value="pageloader-hide" <?php selected( $bonfire_pageloader_selected_class, 'pageloader-hide' ); ?>>No</option>
				<!-- Options end here -->	
			</select>		
		</p>
		<?php	
	}

	add_action( 'save_post', 'bonfire_pageloader_custom_class_save' );
	function bonfire_pageloader_custom_class_save( $post_id ) {
		if( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return;
		}
		if( !current_user_can( 'edit_post' ) ) {
			return;
		}
			
		if( isset( $_POST['bonfire_pageloader_display'] ) ) {
			update_post_meta( $post_id, 'bonfire_pageloader_display', esc_attr( $_POST['bonfire_pageloader_display'] ) );
		}
	}

?>